function JLabel(owner, parent, name, dataset, field, caption, alignment, rect, tab)
{
	var self = this,
		_disposed = false;

	this.initialize(owner, parent, name, caption, null, rect, null, field, dataset, tab);

	this.alignment = parseInt(utils.coalesce(alignment, laNone));
	this.methods  = (cmRender | cmLoad);

	this.render = render;
	this.load = load;
	this.dispose = dispose;
	this.bind_setValue = bind_setValue;

	function render(fs)
	{
		var caption = self.caption;
		if ((dataset != null) && (!utils.isEmpty(self.field)))
			caption = dataset.getText(self.field);

		fs.append('<span id="' + self.name + '" class="label" style="' + self.rect + '">' + caption + (self.alignment == laLeft ? paddingDots : '') + '</span>');
	}

	function load()
	{
		if ((dataset != null) && (! utils.isEmpty(self.field)))
			dataset.bindingManager.bind(self, '', self.field);
	}

	function bind_setValue(prop, field, record)
	{
		if (field == self.field)
			/*self.$$().firstChild.nodeValue*/ self.$$().innerHTML = record.dataset.getText(self.field) + (self.alignment == laLeft ? paddingDots : '');
	}

	function dispose()
	{
		if (_disposed)
		  return;

		if ((dataset != null) && (dataset.bindingManager != null) && (! utils.isEmpty(self.field)))
			dataset.bindingManager.unbind(self);
			
		self.base.dispose.call(self);
		_disposed = true;
	}
}

JLabel.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();